/*-
# X-BASED RUBIK'S CUBE(tm)
#
#  Rubik.h
#
###
#
#  Copyright (c) 1994 - 2007	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Rubik */

#ifndef _XtRubik_h
#define _XtRubik_h

/***********************************************************************
 *
 * Rubik Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNframeColor ((char *) "frameColor")
#define XtNfaceColor0 ((char *) "faceColor0")
#define XtNfaceColor1 ((char *) "faceColor1")
#define XtNfaceColor2 ((char *) "faceColor2")
#define XtNfaceColor3 ((char *) "faceColor3")
#define XtNfaceColor4 ((char *) "faceColor4")
#define XtNfaceColor5 ((char *) "faceColor5")
#define XtNpieceBorder ((char *) "pieceBorder")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNview ((char *) "view")
#define XtNsizex ((char *) "sizex")
#define XtNsizey ((char *) "sizey")
#define XtNsizez ((char *) "sizez")
#define XtNorient ((char *) "orient")
#define XtNpractice ((char *) "practice")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNface ((char *) "face")
#define XtNpos ((char *) "position")
#define XtNdirection ((char *) "direction")
#define XtNcontrol ((char *) "control")
#define XtNfast ((char *) "fast")
#define XtNpixmapSize ((char *) "pixmapSize")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCView ((char *) "View")
#define XtCSizeX ((char *) "SizeX")
#define XtCSizeY ((char *) "SizeY")
#define XtCSizeZ ((char *) "SizeZ")
#define XtCOrient ((char *) "Orient")
#define XtCPractice ((char *) "Practice")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCMenu ((char *) "Menu")
#define XtCFace ((char *) "Face")
#define XtCPos ((char *) "Position")
#define XtCDirection ((char *) "Direction")
#define XtCControl ((char *) "Control")
#define XtCFast ((char *) "Fast")
#define XtCPixmapSize ((char *) "PixmapSize")

typedef struct _RubikClassRec *RubikWidgetClass;

extern WidgetClass rubikWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
	int         face, position, direction;
	Boolean     control;
	int         fast;
} rubikCallbackStruct;
#endif

#define ACTION_GET 100
#define ACTION_WRITE 101
#define ACTION_EXIT 102
#define ACTION_HIDE 103
#define ACTION_PRACTICE_QUERY 104
#define ACTION_RANDOMIZE_QUERY 105
#define ACTION_SOLVE_MESSAGE 106
#define ACTION_RESTORE 107
#define ACTION_RESET 108
#define ACTION_AMBIGUOUS 109
#define ACTION_ILLEGAL 110
#define ACTION_MOVED 111
#define ACTION_CONTROL 112
#define ACTION_SOLVED 113
#define ACTION_COMPUTED 114
#define ACTION_UNDO 200
#define ACTION_REDO 201
#define ACTION_CLEAR 202
#define ACTION_PRACTICE 203
#define ACTION_RANDOMIZE 204
#define ACTION_SOLVE 205
#define ACTION_INCREMENT 206
#define ACTION_DECREMENT 207
#define ACTION_ORIENTIZE 208
#define ACTION_SPEED 209
#define ACTION_SLOW 210
#define ACTION_SOUND 211
#define ACTION_VIEW 212
#define ACTION_DIM 213
#define ACTION_TOP 300
#define ACTION_RIGHT 301
#define ACTION_BOTTOM 302
#define ACTION_LEFT 303
#define ACTION_CW 305
#define ACTION_CCW 307
#define ACTION_TR 308
#define ACTION_BR 309
#define ACTION_BL 310
#define ACTION_TL 311
#define ACTION_CONTROL_TOP 340
#define ACTION_CONTROL_RIGHT 341
#define ACTION_CONTROL_BOTTOM 342
#define ACTION_CONTROL_LEFT 343
#define ACTION_CONTROL_CW 345
#define ACTION_CONTROL_CCW 347
#define ACTION_CONTROL_TR 348
#define ACTION_CONTROL_BR 349
#define ACTION_CONTROL_BL 350
#define ACTION_CONTROL_TL 351
#define ACTION_INCX 400
#define ACTION_DECX 401
#define ACTION_INCY 402
#define ACTION_DECY 403
#define ACTION_INCZ 404
#define ACTION_DECZ 405
#define ACTION_DESCRIPTION 900
#define ACTION_FEATURES 901
#define ACTION_REFERENCES 902
#define ACTION_ABOUT 903
#define ACTION_IGNORE 999

#define RESTORE_DIR (-5)
#define CLEAR_DIR (-4)
#define AMBIGUOUS_DIR (-3)
#define ILLEGAL_DIR (-2)
#define IGNORE_DIR (-1)
#define MAXORIENT 4
#define MAXFACES 6
#define MAXVIEWS 2
#define MINFACETS 1
#define DEFAULTFACETS 3
#define DEFAULTORIENT FALSE
#define DEFAULTPRACTICE TRUE
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE

#define BOOL_STRING(a) ((a==0)?"false":"true")

typedef struct _RubikRec *RubikWidget;

#endif /* _XtRubik_h */
/* DON'T ADD STUFF AFTER THIS #endif */
