/*
 * Copyright 2004-2007 Luc Verhaegen.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _VIA_OUTPUT_H_
#define _VIA_OUTPUT_H_ 1

/* For Output->Type */
#define OUTPUT_NONE   0x00
#define OUTPUT_CRT    0x01
#define OUTPUT_TV     0x02
#define OUTPUT_PANEL  0x04  /* TTL */
#define OUTPUT_LVDS   0x08  /* usually also a panel */
#define OUTPUT_TMDS   0x10  /* DVI */

/*
 * For Output->Position
 */
#define OUTPUT_BUS_UNKNOWN  0x00
#define OUTPUT_BUS_CRT      0x01
#define OUTPUT_BUS_DVP0     0x02
#define OUTPUT_BUS_DVP1     0x03
#define OUTPUT_BUS_DFP      0x04
#define OUTPUT_BUS_DFPLOW   0x05
#define OUTPUT_BUS_DFPHIGH  0x06

/*
 * Main Output structure.
 */
struct ViaOutput {
    struct ViaOutput *  Prev;
    struct ViaOutput *  Next;

    int  scrnIndex;

    char *Name;

    /* driver side */
    int  Owner; /* Which head owns this? - Driver only. */
    int  Position; /* What bus is this connected to? - Driver only. */
    Bool  Active;
    Bool  ClockMaster;
    Bool  ModesExclusive; /* This output will only accept its own modes. */

    /* Shared - 0 when unused */
    CARD32  Type;

    /* Shared - Null when unused */
    I2CDevPtr  I2CDev;
    xf86MonPtr EDID;
    OptionInfoPtr  Options;

    void (*Save) (struct ViaOutput *Output);
    void (*Restore) (struct ViaOutput *Output);
    Bool (*Sense) (struct ViaOutput *Output);
    ModeStatus (*ModeValid) (struct ViaOutput *Output, DisplayModePtr mode); /* Required */
    void (*Mode) (struct ViaOutput *Output, DisplayModePtr mode); /* Required */
    void (*Power) (struct ViaOutput *Output, Bool On); /* Required */
    void (*PrintRegs) (struct ViaOutput *Output, const char *function);

    /* old MonRec fields -- will probably be abstracted out again in future */
    char *MonitorName;

    int numHSync; /* default: 0 */
    range HSync[MAX_HSYNC];
    int numVRefresh; /* default: 0 */
    range VRefresh[MAX_VREFRESH];
    DisplayModePtr Modes; /* default: NULL */
    int MaxClock; /* default 0 */
    Bool ReducedAllowed;

    /* Privates. */
    int  PrivFlag;
    void  *Private;
    int  PrivSize;
    void (*PrivateDestroy) (struct ViaOutput *Output);
};

/* Function prototypes */
void ViaOutputsDestroy(ScrnInfoPtr pScrn);
void ViaOutputsSave(ScrnInfoPtr pScrn);
void ViaOutputsRestore(ScrnInfoPtr pScrn);
void ViaOutputAddModetable(struct ViaOutput *Output, DisplayModePtr Modes);
int ViaModeOutputValid(struct ViaOutput *Output, DisplayModePtr Mode);
void ViaOutputsPrintRegs(ScrnInfoPtr pScrn, const char *function);
void ViaOutputsDetect(ScrnInfoPtr pScrn);
Bool ViaOutputsSelect(ScrnInfoPtr pScrn);
void ViaOutputModesCopyAdd(struct ViaOutput *Output, DisplayModePtr Additions);

#ifdef HAVE_VIA_CRTC_H
void ViaOutputBusPower(struct ViaCrtc *Crtc, int Bus, Bool On);
void ViaOutputBusSet(struct ViaCrtc *Crtc, int Bus);

void ViaOutputsPower(struct ViaCrtc *Crtc, Bool On);
void ViaOutputsGamma(ScrnInfoPtr pScrn, Bool On);
void ViaOutputTimingSetFromConfig(ScrnInfoPtr pScrn);

#endif

/* via_edid.c */
#ifdef XF86_DDC_H /* don't impose xf86DDC.h on all files */
void ViaOutputEDIDSet(struct ViaOutput *Output, xf86MonPtr EDID);
#endif

/* outputs: via_crt.c, via_panel.c, via_vt162x.c and via_ch7xxx.c */
struct ViaOutput *ViaCRTInit(ScrnInfoPtr pScrn, I2CDevPtr pDev);
struct ViaOutput *ViaPanelInit(ScrnInfoPtr pScrn, I2CDevPtr pDev);
struct ViaOutput *ViaVT162xInit(ScrnInfoPtr pScrn, I2CDevPtr pDev);
struct ViaOutput *ViaSiI16xInit(ScrnInfoPtr pScrn, I2CDevPtr pDev);
struct ViaOutput *ViaCH7xxxInit(ScrnInfoPtr pScrn, I2CDevPtr pDev);

#endif /* _VIA_OUTPUT_H_ */
