/*******************************************************************
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef __CONFIG_SSID_H__
#define __CONFIG_SSID_H__

struct found_ssids {
  char *ssid_name;
  u_char abilities;
  u_char *wpa_ie;
  u_char wpa_ie_len;
  u_char *rsn_ie;
  u_char rsn_ie_len;
  u_char mac[6];
  unsigned int freq;
  unsigned char quality;
  char signal;
  char noise;

  struct found_ssids *next;
};

void config_ssid_clear();
char *config_ssid_get_desired_ssid(struct interface_data *);
u_char config_ssid_get_ssid_abilities();
void config_ssid_get_wpa_ie(u_char **, u_char *);
void config_ssid_get_rsn_ie(u_char **, u_char *);
unsigned int config_ssid_get_freq();
u_char *config_ssid_get_mac();
void config_ssid_dump();
int config_ssid_using_wep();
int config_ssid_ssid_known(char *);

// Functions to add information to an existing ESSID node.
void config_ssid_add_freq(unsigned int);
void config_ssid_add_bssid(char *);
void config_ssid_add_rsn_ie(u_char *, u_char);
void config_ssid_add_wpa_ie(u_char *, u_char);
void config_ssid_add_ssid_name(char *);
void config_ssid_update_abilities(u_char);
void config_ssid_add_qual(unsigned char, char, char);

#endif
