/*
 * Copyright (c) 1998, 1999, Bjorn Lindgren <bjorn@500mhz.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by
 *      Bjorn Lindgren <bjorn@500mhz.net>.
 * 4. Neither the name of the authors nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

/* $Id$ */

#ifndef _XWHOIS_H_
#define _XWHOIS_H_

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <termios.h>
#include <netdb.h>
/* #include <ctype.h> */      /* not used */
#include <sys/types.h>
#include <sys/stat.h>
/* #include <sys/syslog.h> */ /* not used */
/* #include <sys/param.h> */  /* not used */
/* #include <sys/times.h> */  /* not used */
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/signal.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <gtk/gtk.h>

#ifndef FORKNPIPE
#ifdef HAVE_PTHREAD_H
#ifndef _REENTRANT
#define _REENTRANT
#endif /* _REENTRANT */
#include <pthread.h>
#endif /* HAVE_PTHREAD_H */
#endif /* FORKNPIPE */

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

/*
 * C compiler prototype defines.
 */

#ifndef __P
#ifdef __STDC__
#define __P(protos) protos /* ANSI C */
#else
#define __(protos) () /* traditional C preprocessor */
#endif
#endif

/*
 * Prototype declarations for some non ANSI C functions.
 */

char *strdup __P((const char *));
int snprintf __P((char *, size_t, const char *, ...));
FILE *popen __P((const char *, const char *));

/*
 * For systems lacking <cdefs.h>
 */

#ifndef __DECLS
#define __BEGIN_DECLS
#define __END_DECLS
#endif

/*
 * Xwhois defines.
 */

#define PORT 43
#define BUFSIZE 1024
#define TIMEOUT 10 /* timeout in seconds for connect() and read() */
#define HISTFILE "/.xwhois.history"
#define SERVFILE "/.xwhois.servers"

/*
 * Xwhois shared structs.
 */

struct serverent {
  char *name;
  char *comment;
} servers[256];

struct navent {
  char *object; /* the search object string */
  char *server; /* whois server chosen from the server list */
  gint server_pos; /* position of server in server file */
};

struct histent {
  char *object;
  char *server;
};

/*
 * Xwhois shared variables.
 */

int FLAG;
int HELP_FLAG;
int HIST_FLAG;
int ABOUT_DIALOG_FLAG;
int SERVER_DIALOG_FLAG;
GtkWidget *text_field;
GtkWidget *text_field_list;
GtkWidget *b_submit;
GtkWidget *server_list;
GtkWidget *statusbar;
GtkCombo *history_combo;
GList *history_list;
char text_buffer[256][102400]; /* max 256 text buffers */
char server[256];
struct navent *ne;
struct histent *he;

/*
 * External function declarations.
 */

extern void write_history(char *);
extern void clear_history(void);
extern void about_window(GtkWidget *, gpointer);
extern void about_close(GtkWidget *,GtkWidget *);
extern void whois_dialog(void);
extern void get_servers(void);
extern void get_history(void);
extern void gui_set_text(GtkWidget *, char *);
extern void set_text_list(char *);
extern void navigator_add(char *);
extern void navigator_back(void);
extern void navigator_forward(void);
extern char *getsrvbyobj(char *);
extern char *getobjbysrv(char *);
extern int getsrvpos(char *);
extern int getsrvnum(void);
extern char *probe_internal(char *, int);
extern int probe_internal_warper(void);
extern void probe_external_whois(void);
extern void probe_external_fwhois(void);
extern void scan_servers(void);
extern void scan_forknpipe(void);
extern void scan_pthreads(void);
extern void *scan_pthreads_t(void *);

#endif /* _XWHOIS_H_ */
