#!perl -w
#
# CcwTab -- encapsulate modules.ccwmap
#   Copyright (C) 2005  Erik van Konijnenburg
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
#
# This table describes hardware used on the s390.
#

use strict;
use warnings;
use Base;
use Conf;
use CcwMapEntry;
package CcwTab;

my $ccwList = undef;

# Parse this:
# # ccw module         match_flags cu_type cu_model dev_type dev_model
# zfcp                 0x000f      0x1731  0x03      0x1732  0x03
# zfcp                 0x000f      0x1731  0x03      0x1732  0x04
# qeth                 0x0003      0x1731  0x01      0x0000  0x00

sub init () {
	if (defined ($ccwList)) {
		return;
	}
	$ccwList = [];
	my $name = Conf::get('ccwMap');
	if (! open (IN, "<", "$name")) {
		Base::fatal ("can't open ccw module list $name");
	}
	while (defined (my $line = <IN>)) {
		chomp $line;
		$line =~ s/#.*//;
		$line =~ s/^\s+//;
		$line =~ s/\s+$//;
		next if ($line eq "");
		my @fields = split (/\s+/, $line, 999);
		if ($#fields != 5) {
			Base::fatal "malformed line in ccw module list $name";
		}
		push @{$ccwList}, CcwMapEntry->new (
			module => $fields[0],
			match_flags => hex ($fields[1]),
			cu_type => hex ($fields[2]),
			cu_model => hex ($fields[3]),
			dev_type => hex ($fields[4]),
			dev_model => hex ($fields[5]),
			);
	}
	if (! close (IN)) {
		Base::fatal "could not read ccw module list $name";
	}
}

sub all	() {
	init;
	return $ccwList;
}

# given pathname in devices tree, find module name in PCI map as a list.
sub find ($) {
	my ($dev) = @_;
	my @result = ();
	for my $cme (@{CcwTab::all()}) {
		if ($cme->matches ($dev)) {
			push @result, $cme->module;
		}
	}
	return [@result];
}


1;

