#ifndef SOUNDPATHS_H
#define SOUNDPATHS_H

#include <sys/types.h>
#include "ytypes.h"

/*
 *	Sound path structure:
 */
typedef struct {

	char *path;

} SoundPath;

extern SoundPath **soundpath;
extern int total_soundpaths;


/*
 *	Functions:
 */
extern int SoundPathIsAllocated(int n);
extern SoundPath *SoundPathGetPtr(int n);

extern char *SoundPathCompletePath(const char *filename);

extern int SoundPathAllocate();
extern void SoundPathDelete(int n);
extern void SoundPathDeleteAll();


#endif	/* SOUNDPATHS_H */
