/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import Ice.Identity;
import Ice.IdentityParseException;
import Ice.Util;
import IceGrid.AdapterDescriptor;
import IceGrid.ObjectDescriptor;
import IceGridGUI.Application.Adapter;
import IceGridGUI.Application.Communicator;
import IceGridGUI.Application.CommunicatorChildEditor;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.MapField;
import IceGridGUI.Application.ReplicaGroup;
import IceGridGUI.Application.ReplicaGroups;
import IceGridGUI.Utils;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class AdapterEditor
extends CommunicatorChildEditor {
    private String _defaultAdapterId = "";
    private final Object DEFAULT_ADAPTER_ID = new Object(){

        public String toString() {
            return AdapterEditor.this._defaultAdapterId;
        }
    };
    private String _oldName;
    private JTextField _name = new JTextField(20);
    private JTextArea _description = new JTextArea(3, 20);
    private JComboBox _id = new JComboBox<Object>(new Object[]{this.DEFAULT_ADAPTER_ID});
    private JComboBox _replicaGroupId = new JComboBox();
    private JButton _replicaGroupButton;
    private JTextField _priority = new JTextField(20);
    private JTextField _endpoints = new JTextField(20);
    private JComboBox _publishedEndpoints = new JComboBox<Object>(new Object[]{PUBLISH_ACTUAL});
    private JTextField _currentStatus = new JTextField(20);
    private JTextField _currentEndpoints = new JTextField(20);
    private JCheckBox _registerProcess;
    private JCheckBox _serverLifetime;
    private MapField _objects = new MapField((Editor)this, "Identity", new String[]{"Type", "Property"}, true);
    private LinkedList _objectList;
    private MapField _allocatables = new MapField((Editor)this, "Identity", new String[]{"Type", "Property"}, true);
    private LinkedList _allocatableList;
    private static final Object PUBLISH_ACTUAL = new Object(){

        public String toString() {
            return "Actual endpoints";
        }
    };
    private static final Object NOT_REPLICATED = new Object(){

        public String toString() {
            return "Does not belong to a replica group";
        }
    };

    AdapterEditor() {
        AbstractAction gotoReplicaGroup = new AbstractAction("", Utils.getIcon("/icons/16x16/goto.png")){

            public void actionPerformed(ActionEvent e) {
                Object obj = AdapterEditor.this._replicaGroupId.getSelectedItem();
                Adapter adapter = AdapterEditor.this.getAdapter();
                ReplicaGroup rg = null;
                if (obj instanceof ReplicaGroup) {
                    rg = (ReplicaGroup)obj;
                } else {
                    String replicaGroupId = Utils.substitute(obj.toString(), adapter.getResolver());
                    rg = adapter.getRoot().findReplicaGroup(replicaGroupId);
                }
                if (rg != null) {
                    adapter.getRoot().setSelectedNode(rg);
                }
            }
        };
        gotoReplicaGroup.putValue("ShortDescription", "Goto the definition of this replica group");
        this._replicaGroupButton = new JButton(gotoReplicaGroup);
        AbstractAction checkRegisterProcess = new AbstractAction("Register Process"){

            public void actionPerformed(ActionEvent e) {
                AdapterEditor.this.updated();
            }
        };
        this._registerProcess = new JCheckBox(checkRegisterProcess);
        this._registerProcess.setToolTipText("<html>During activation, create a Process object<br>in this adapter and register it with IceGrid<br>to enable clean shutdown; you should register<br>exactly one Process object per server.</html>");
        AbstractAction checkServerLifetime = new AbstractAction("Server Lifetime"){

            public void actionPerformed(ActionEvent e) {
                AdapterEditor.this.updated();
            }
        };
        this._serverLifetime = new JCheckBox(checkServerLifetime);
        this._serverLifetime.setToolTipText("<html>Is the adapter lifetime the same as the server<br>lifetime? The server is considered to be active<br>only if all the adapters with this attribute set<br>to true are active.</html>");
        this._name.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                AdapterEditor.this.updated();
                AdapterEditor.this._defaultAdapterId = AdapterEditor.this.getAdapter().getDefaultAdapterId(AdapterEditor.this._name.getText().trim());
                AdapterEditor.this.refreshId();
            }
        });
        this._name.setToolTipText("Identifies this object adapter within an Ice communicator");
        this._endpoints.getDocument().addDocumentListener(this._updateListener);
        this._endpoints.setToolTipText("<html>The network interface(s) on which this object adapter receives requests;<br>for example:<br> tcp (listen on all local interfaces using a random port)<br> tcp -h venus.foo.com (listen on just one interface)<br> tcp -t 10000 (sets a timeout of 10,000 milliseconds)<br> ssl -h venus.foo.com (accepts SSL connections instead of plain TCP)</html>");
        this._description.getDocument().addDocumentListener(this._updateListener);
        this._description.setToolTipText("An optional description for this object adapter");
        JTextField idTextField = (JTextField)this._id.getEditor().getEditorComponent();
        idTextField.getDocument().addDocumentListener(this._updateListener);
        this._id.setToolTipText("Identities this object adapter within an IceGrid deployment");
        JTextField replicaGroupIdTextField = (JTextField)this._replicaGroupId.getEditor().getEditorComponent();
        replicaGroupIdTextField.getDocument().addDocumentListener(this._updateListener);
        this._replicaGroupId.setToolTipText("Select a replica group");
        this._priority.getDocument().addDocumentListener(this._updateListener);
        this._priority.setToolTipText("The priority of this adapter; see the Ordered load-balancing policy in Replica Groups");
        JTextField publishedEndpointsTextField = (JTextField)this._publishedEndpoints.getEditor().getEditorComponent();
        publishedEndpointsTextField.getDocument().addDocumentListener(this._updateListener);
        this._publishedEndpoints.setToolTipText("Endpoints registered with the IceGrid Registry during the activation of this adapter.");
    }

    void writeDescriptor() {
        AdapterDescriptor descriptor = (AdapterDescriptor)this.getAdapter().getDescriptor();
        descriptor.name = this._name.getText().trim();
        descriptor.description = this._description.getText();
        descriptor.id = this.getIdAsString();
        descriptor.replicaGroupId = this.getReplicaGroupIdAsString();
        descriptor.priority = this._priority.getText().trim();
        descriptor.registerProcess = this._registerProcess.isSelected();
        descriptor.serverLifetime = this._serverLifetime.isSelected();
        descriptor.objects = this._objectList;
        descriptor.allocatables = this._allocatableList;
    }

    boolean isSimpleUpdate() {
        AdapterDescriptor descriptor = (AdapterDescriptor)this.getAdapter().getDescriptor();
        return descriptor.name.equals(this._name.getText().trim());
    }

    Communicator.ChildList getChildList() {
        return ((Communicator)this._target.getParent()).getAdapters();
    }

    protected void appendProperties(DefaultFormBuilder builder) {
        builder.append("Adapter Name");
        builder.append((Component)this._name, 3);
        builder.nextLine();
        builder.append("Description");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-2);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this._description);
        builder.add(scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 3));
        builder.nextRow(2);
        builder.nextLine();
        builder.append("Adapter ID");
        builder.append((Component)this._id, 3);
        builder.nextLine();
        builder.append("Replica Group", (Component)this._replicaGroupId);
        builder.append(this._replicaGroupButton);
        builder.nextLine();
        builder.append("Priority");
        builder.append((Component)this._priority, 3);
        builder.nextLine();
        builder.append("Endpoints");
        builder.append((Component)this._endpoints, 3);
        builder.nextLine();
        builder.append("Published Endpoints");
        builder.append((Component)this._publishedEndpoints, 3);
        builder.nextLine();
        builder.append("", (Component)this._registerProcess);
        builder.nextLine();
        builder.append("", (Component)this._serverLifetime);
        builder.nextLine();
        builder.append("Well-known Objects");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        scrollPane = new JScrollPane(this._objects);
        builder.add(scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
        builder.append("Allocatable Objects");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        scrollPane = new JScrollPane(this._allocatables);
        builder.add(scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
    }

    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Adapter Properties");
    }

    void postUpdate() {
        String[] value;
        String key;
        Map.Entry entry;
        String name = this._name.getText().trim();
        Adapter adapter = this.getAdapter();
        if (!name.equals(this._oldName)) {
            adapter.removeProperty(this._oldName + ".Endpoints");
            adapter.removeProperty(this._oldName + ".PublishedEndpoints");
            this._oldName = name;
        }
        adapter.setProperty(name + ".Endpoints", this._endpoints.getText().trim());
        Object published = this._publishedEndpoints.getSelectedItem();
        if (published == PUBLISH_ACTUAL) {
            adapter.removeProperty(name + ".PublishedEndpoints");
        } else {
            adapter.setProperty(name + ".PublishedEndpoints", published.toString().trim());
        }
        TreeMap map = this._objects.get();
        Iterator p = map.entrySet().iterator();
        while (p.hasNext()) {
            entry = p.next();
            key = (String)entry.getKey();
            value = (String[])entry.getValue();
            if (value[1].equals("")) continue;
            adapter.setProperty(value[1], key);
        }
        map = this._allocatables.get();
        p = map.entrySet().iterator();
        while (p.hasNext()) {
            entry = p.next();
            key = (String)entry.getKey();
            value = (String[])entry.getValue();
            if (value[1].equals("")) continue;
            adapter.setProperty(value[1], key);
        }
    }

    private void setId(String id) {
        if (id.equals(this._defaultAdapterId)) {
            this._id.setSelectedItem(this.DEFAULT_ADAPTER_ID);
        } else {
            this._id.setSelectedItem(id);
        }
    }

    private void refreshId() {
        Object id = this._id.getSelectedItem();
        this._id.setModel(new DefaultComboBoxModel<Object>(new Object[]{this.DEFAULT_ADAPTER_ID}));
        this._id.setSelectedItem(id);
    }

    private String getIdAsString() {
        Object obj = this._id.getSelectedItem();
        return obj.toString().trim();
    }

    private void setReplicaGroupId(String replicaGroupId) {
        if (replicaGroupId.equals("")) {
            this._replicaGroupId.setSelectedItem(NOT_REPLICATED);
        } else {
            ReplicaGroups replicaGroups = this.getAdapter().getRoot().getReplicaGroups();
            ReplicaGroup replicaGroup = (ReplicaGroup)replicaGroups.findChild(replicaGroupId);
            if (replicaGroup != null) {
                this._replicaGroupId.setSelectedItem(replicaGroup);
            } else {
                this._replicaGroupId.setSelectedItem(replicaGroupId);
            }
        }
    }

    private String getReplicaGroupIdAsString() {
        Object obj = this._replicaGroupId.getSelectedItem();
        if (obj == NOT_REPLICATED) {
            return "";
        }
        return obj.toString().trim();
    }

    protected boolean validate() {
        this._objectList = this.mapToObjectDescriptorSeq(this._objects.get());
        if (this._objectList == null) {
            return false;
        }
        this._allocatableList = this.mapToObjectDescriptorSeq(this._allocatables.get());
        if (this._allocatableList == null) {
            return false;
        }
        return this.check(new String[]{"Adapter Name", this._name.getText().trim(), "Adapter ID", this.getIdAsString(), "Endpoints", this._endpoints.getText().trim()});
    }

    void show(Adapter adapter) {
        this.detectUpdates(false);
        this._target = adapter;
        AdapterDescriptor descriptor = (AdapterDescriptor)adapter.getDescriptor();
        final Utils.Resolver resolver = adapter.getCoordinator().substitute() ? adapter.getResolver() : null;
        boolean isEditable = resolver == null;
        this._oldName = descriptor.name;
        this._name.setText(Utils.substitute(descriptor.name, resolver));
        this._name.setEditable(isEditable);
        String oaPrefix = descriptor.name + ".";
        this._description.setText(Utils.substitute(descriptor.description, resolver));
        this._description.setEditable(isEditable);
        this._description.setOpaque(isEditable);
        this._id.setEnabled(true);
        this._id.setEditable(true);
        this._defaultAdapterId = adapter.getDefaultAdapterId();
        this.refreshId();
        if (descriptor.id == null) {
            descriptor.id = this._defaultAdapterId;
        }
        this.setId(Utils.substitute(descriptor.id, resolver));
        this._id.setEnabled(isEditable);
        this._id.setEditable(isEditable);
        this._replicaGroupId.setEnabled(true);
        this._replicaGroupId.setEditable(true);
        final ReplicaGroups replicaGroups = adapter.getRoot().getReplicaGroups();
        this._replicaGroupId.setModel(replicaGroups.createComboBoxModel(NOT_REPLICATED));
        this._replicaGroupId.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object item = e.getItem();
                    boolean enabled = item instanceof ReplicaGroup;
                    if (!enabled && item != NOT_REPLICATED && resolver != null) {
                        String replicaGroupId = resolver.substitute(item.toString().trim());
                        enabled = replicaGroups.findChild(replicaGroupId) != null;
                    }
                    AdapterEditor.this._replicaGroupButton.setEnabled(enabled);
                }
            }
        });
        this.setReplicaGroupId(Utils.substitute(descriptor.replicaGroupId, resolver));
        this._replicaGroupId.setEnabled(isEditable);
        this._replicaGroupId.setEditable(isEditable);
        this._priority.setText(Utils.substitute(descriptor.priority, resolver));
        this._priority.setEditable(isEditable);
        String endpoints = Utils.substitute(adapter.getProperty(oaPrefix + "Endpoints"), resolver);
        if (adapter.isEphemeral() && (endpoints == null || endpoints.equals(""))) {
            this._endpoints.setText("default");
        } else {
            this._endpoints.setText(endpoints);
        }
        this._endpoints.setEditable(isEditable);
        this._publishedEndpoints.setEnabled(true);
        this._publishedEndpoints.setEditable(true);
        String published = Utils.substitute(adapter.getProperty(oaPrefix + "PublishedEndpoints"), resolver);
        if (published == null || published.equals("")) {
            this._publishedEndpoints.setSelectedItem(PUBLISH_ACTUAL);
        } else {
            this._publishedEndpoints.setSelectedItem(published);
        }
        this._publishedEndpoints.setEnabled(isEditable);
        this._publishedEndpoints.setEditable(isEditable);
        this._objects.set(this.objectDescriptorSeqToMap(descriptor.objects), resolver, isEditable);
        this._allocatables.set(this.objectDescriptorSeqToMap(descriptor.allocatables), resolver, isEditable);
        this._registerProcess.setSelected(descriptor.registerProcess);
        this._registerProcess.setEnabled(isEditable);
        this._serverLifetime.setSelected(descriptor.serverLifetime);
        this._serverLifetime.setEnabled(isEditable);
        this._applyButton.setEnabled(adapter.isEphemeral());
        this._discardButton.setEnabled(adapter.isEphemeral());
        this.detectUpdates(true);
        if (adapter.isEphemeral()) {
            this.updated();
        }
    }

    Adapter getAdapter() {
        return (Adapter)this._target;
    }

    private Map objectDescriptorSeqToMap(List objects) {
        TreeMap<String, String[]> result = new TreeMap<String, String[]>();
        Iterator p = objects.iterator();
        while (p.hasNext()) {
            ObjectDescriptor od = (ObjectDescriptor)p.next();
            String k = Util.identityToString(od.id);
            result.put(k, new String[]{od.type, this.getAdapter().lookupPropertyValue(k)});
        }
        return result;
    }

    private LinkedList mapToObjectDescriptorSeq(Map map) {
        String badIdentities = "";
        LinkedList<ObjectDescriptor> result = new LinkedList<ObjectDescriptor>();
        Iterator p = map.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            try {
                Identity id = Util.stringToIdentity((String)entry.getKey());
                String[] val = (String[])entry.getValue();
                result.add(new ObjectDescriptor(id, val[0]));
            }
            catch (IdentityParseException ex) {
                badIdentities = badIdentities + "- " + (String)entry.getKey() + "\n";
            }
        }
        if (!badIdentities.equals("")) {
            JOptionPane.showMessageDialog(this._target.getCoordinator().getMainFrame(), "The following identities could not be parsed properly:\n" + badIdentities, "Validation failed", 0);
            return null;
        }
        return result;
    }
}

