/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.CommunicatorDescriptor;
import IceGrid.DbEnvDescriptor;
import IceGrid.ServiceDescriptor;
import IceGrid.ServiceInstanceDescriptor;
import IceGridGUI.Application.Adapter;
import IceGridGUI.Application.Communicator;
import IceGridGUI.Application.DbEnv;
import IceGridGUI.Application.Editable;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.PlainServiceEditor;
import IceGridGUI.Application.PropertySet;
import IceGridGUI.Application.Server;
import IceGridGUI.Application.Service;
import IceGridGUI.Application.ServiceInstance;
import IceGridGUI.Application.UpdateFailedException;
import IceGridGUI.ApplicationActions;
import IceGridGUI.Utils;
import IceGridGUI.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class PlainService
extends Communicator
implements Service,
Cloneable {
    private ServiceInstanceDescriptor _descriptor;
    private final boolean _ephemeral;
    private Utils.Resolver _resolver;
    private PlainServiceEditor _editor;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static JPopupMenu _popup;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ServiceDescriptor copyDescriptor(ServiceDescriptor sd) {
        ServiceDescriptor copy = (ServiceDescriptor)sd.clone();
        copy.adapters = Adapter.copyDescriptors(copy.adapters);
        copy.dbEnvs = DbEnv.copyDescriptors(copy.dbEnvs);
        copy.propertySet = PropertySet.copyDescriptor(copy.propertySet);
        return copy;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _cellRenderer.setOpenIcon(Utils.getIcon("/icons/16x16/service.png"));
            _cellRenderer.setClosedIcon(Utils.getIcon("/icons/16x16/service.png"));
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        actions[13] = !this._ephemeral;
        Object clipboard = this.getCoordinator().getClipboard();
        if (clipboard != null && (clipboard instanceof ServiceInstanceDescriptor || clipboard instanceof Adapter.AdapterCopy || clipboard instanceof DbEnvDescriptor)) {
            actions[14] = true;
        }
        actions[15] = true;
        actions[0] = !this._ephemeral;
        boolean bl = actions[1] = !this._ephemeral;
        if (this._parent instanceof Server && !this._ephemeral) {
            actions[16] = true;
            actions[17] = true;
        }
        actions[18] = this.canMove(true);
        actions[19] = this.canMove(false);
        return actions;
    }

    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(0));
            _popup.add(actions.get(1));
            _popup.addSeparator();
            _popup.add(actions.get(18));
            _popup.add(actions.get(19));
        }
        actions.setTarget(this);
        return _popup;
    }

    public void copy() {
        this.getCoordinator().setClipboard(ServiceInstance.copyDescriptor(this._descriptor));
        this.getCoordinator().getActionsForMenu().get(14).setEnabled(true);
    }

    public void moveUp() {
        this.move(true);
    }

    public void moveDown() {
        this.move(false);
    }

    public Object getDescriptor() {
        return this._descriptor;
    }

    public Object saveDescriptor() {
        return this._descriptor.clone();
    }

    public void restoreDescriptor(Object savedDescriptor) {
        ServiceInstanceDescriptor sid = (ServiceInstanceDescriptor)savedDescriptor;
        this._descriptor.descriptor.propertySet = sid.descriptor.propertySet;
        this._descriptor.descriptor.description = sid.descriptor.description;
        this._descriptor.descriptor.name = sid.descriptor.name;
        this._descriptor.descriptor.entry = sid.descriptor.entry;
    }

    public void destroy() {
        ((Communicator)this._parent).getServices().destroyChild(this);
    }

    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = (PlainServiceEditor)this.getRoot().getEditor(PlainServiceEditor.class, this);
        }
        this._editor.show(this);
        return this._editor;
    }

    protected Editor createEditor() {
        return new PlainServiceEditor();
    }

    Editable getEnclosingEditable() {
        return ((Communicator)this._parent).getEnclosingEditable();
    }

    private boolean canMove(boolean up) {
        if (this._ephemeral) {
            return false;
        }
        return ((Communicator)this._parent).getServices().canMove(this, up);
    }

    private void move(boolean up) {
        if (!$assertionsDisabled && !this.canMove(up)) {
            throw new AssertionError();
        }
        ((Communicator)this._parent).getServices().move(this, up);
    }

    public Object rebuild(List editables) throws UpdateFailedException {
        PlainService backup;
        PlainService newService;
        block2: {
            Communicator communicator = (Communicator)this._parent;
            Communicator.Services services = communicator.getServices();
            newService = null;
            newService = (PlainService)services.createChild(this._descriptor);
            backup = null;
            try {
                backup = (PlainService)this.clone();
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.reset(newService);
        this.getRoot().getTreeModel().nodeChanged(this);
        return backup;
    }

    public void restore(Object backupObj) {
        this.reset((PlainService)backupObj);
        this.getRoot().getTreeModel().nodeChanged(this);
    }

    private void reset(PlainService from) {
        this._id = from._id;
        if (!$assertionsDisabled && this._parent != from._parent) {
            throw new AssertionError();
        }
        this._adapters = from._adapters;
        this._dbEnvs = from._dbEnvs;
        this._services = from._services;
        this._childListArray = from._childListArray;
        this._descriptor = from._descriptor;
        this._resolver = from._resolver;
    }

    PlainService(Communicator parent, String name, ServiceInstanceDescriptor descriptor, Utils.Resolver resolver) throws UpdateFailedException {
        super(parent, name);
        this._descriptor = descriptor;
        this._ephemeral = false;
        this._resolver = resolver;
        this._adapters.init(this._descriptor.descriptor.adapters);
        this._dbEnvs.init(this._descriptor.descriptor.dbEnvs);
    }

    PlainService(Communicator parent, ServiceInstanceDescriptor descriptor) {
        super(parent, descriptor.descriptor.name);
        this._descriptor = descriptor;
        this._ephemeral = true;
    }

    static List createAttributes(ServiceDescriptor descriptor) {
        LinkedList<String[]> attributes = new LinkedList<String[]>();
        attributes.add(PlainService.createAttribute("name", descriptor.name));
        attributes.add(PlainService.createAttribute("entry", descriptor.entry));
        return attributes;
    }

    void write(XMLWriter writer) throws IOException {
        if (!this._ephemeral) {
            writer.writeStartTag("service", PlainService.createAttributes(this._descriptor.descriptor));
            if (this._descriptor.descriptor.description.length() > 0) {
                writer.writeElement("description", this._descriptor.descriptor.description);
            }
            PlainService.writePropertySet(writer, this._descriptor.descriptor.propertySet, this._descriptor.descriptor.adapters, this._descriptor.descriptor.logs);
            PlainService.writeLogs(writer, this._descriptor.descriptor.logs, this._descriptor.descriptor.propertySet.properties);
            this._adapters.write(writer, this._descriptor.descriptor.propertySet.properties);
            this._dbEnvs.write(writer);
            writer.writeEndTag("service");
        }
    }

    CommunicatorDescriptor getCommunicatorDescriptor() {
        return this._descriptor.descriptor;
    }

    Utils.Resolver getResolver() {
        return this._resolver;
    }

    public boolean isEphemeral() {
        return this._ephemeral;
    }

    static {
        $assertionsDisabled = !PlainService.class.desiredAssertionStatus();
    }
}

