/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.LiveDeployment;

import Ice.LocalException;
import Ice.ObjectPrx;
import Ice.UserException;
import IceGrid.AMI_Admin_getNodeLoad;
import IceGrid.AMI_Admin_shutdownNode;
import IceGrid.AdapterDynamicInfo;
import IceGrid.AdminPrx;
import IceGrid.AdminSessionPrx;
import IceGrid.ApplicationDescriptor;
import IceGrid.FileIteratorPrx;
import IceGrid.FileIteratorPrxHelper;
import IceGrid.FileNotAvailableException;
import IceGrid.LoadInfo;
import IceGrid.NodeDescriptor;
import IceGrid.NodeDynamicInfo;
import IceGrid.NodeInfo;
import IceGrid.NodeNotExistException;
import IceGrid.NodeUnreachableException;
import IceGrid.NodeUpdateDescriptor;
import IceGrid.PropertySetDescriptor;
import IceGrid.ServerDescriptor;
import IceGrid.ServerDynamicInfo;
import IceGrid.ServerInstanceDescriptor;
import IceGrid.ServerState;
import IceGrid.TemplateDescriptor;
import IceGridGUI.LiveActions;
import IceGridGUI.LiveDeployment.Editor;
import IceGridGUI.LiveDeployment.ListTreeNode;
import IceGridGUI.LiveDeployment.NodeEditor;
import IceGridGUI.LiveDeployment.Root;
import IceGridGUI.LiveDeployment.Server;
import IceGridGUI.LiveDeployment.ShowLogDialog;
import IceGridGUI.Utils;
import java.awt.Component;
import java.awt.Cursor;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;

class Node
extends ListTreeNode {
    private final SortedMap _map = new TreeMap();
    private boolean _up = false;
    private NodeDynamicInfo _info;
    private boolean _windows = false;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static Icon _nodeUp;
    private static Icon _nodeDown;
    private static NodeEditor _editor;
    private static JPopupMenu _popup;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[19];
        actions[15] = this._up;
        actions[12] = this._up;
        actions[13] = this._up;
        return actions;
    }

    public void retrieveOutput(final boolean stdout) {
        this.getRoot().openShowLogDialog(new ShowLogDialog.FileIteratorFactory(){

            public FileIteratorPrx open(int count) throws FileNotAvailableException, NodeNotExistException, NodeUnreachableException {
                AdminSessionPrx session = Node.this.getRoot().getCoordinator().getSession();
                FileIteratorPrx result = stdout ? session.openNodeStdOut(Node.this._id, count) : session.openNodeStdErr(Node.this._id, count);
                if (Node.this.getRoot().getCoordinator().getCommunicator().getDefaultRouter() == null) {
                    result = FileIteratorPrxHelper.uncheckedCast(result.ice_endpoints(session.ice_getEndpoints()));
                }
                return result;
            }

            public String getTitle() {
                return "Node " + Node.this._id + " " + (stdout ? "stdout" : "stderr");
            }

            public String getDefaultFilename() {
                return Node.this._id + (stdout ? ".out" : ".err");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNode() {
        final String prefix = "Shutting down node '" + this._id + "'...";
        this.getCoordinator().getStatusBar().setText(prefix);
        AMI_Admin_shutdownNode cb = new AMI_Admin_shutdownNode(){

            public void ice_response() {
                Node.this.amiSuccess(prefix);
            }

            public void ice_exception(UserException e) {
                Node.this.amiFailure(prefix, "Failed to shutdown " + Node.this._id, e);
            }

            public void ice_exception(LocalException e) {
                Node.this.amiFailure(prefix, "Failed to shutdown " + Node.this._id, e.toString());
            }
        };
        try {
            this.getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            this.getCoordinator().getAdmin().shutdownNode_async(cb, this._id);
        }
        catch (LocalException e) {
            this.failure(prefix, "Failed to shutdown " + this._id, e.toString());
        }
        finally {
            this.getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public JPopupMenu getPopupMenu() {
        LiveActions la = this.getCoordinator().getLiveActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(la.get(12));
            _popup.add(la.get(13));
            _popup.addSeparator();
            _popup.add(la.get(15));
        }
        la.setTarget(this);
        return _popup;
    }

    public Editor getEditor() {
        if (_editor == null) {
            _editor = new NodeEditor();
        }
        _editor.show(this);
        return _editor;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _nodeUp = Utils.getIcon("/icons/16x16/node_up.png");
            _nodeDown = Utils.getIcon("/icons/16x16/node_down.png");
        }
        if (this._up) {
            _cellRenderer.setToolTipText("Up and running");
            if (expanded) {
                _cellRenderer.setOpenIcon(_nodeUp);
            } else {
                _cellRenderer.setClosedIcon(_nodeUp);
            }
        } else {
            _cellRenderer.setToolTipText("Not running");
            if (expanded) {
                _cellRenderer.setOpenIcon(_nodeDown);
            } else {
                _cellRenderer.setClosedIcon(_nodeDown);
            }
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    Node(Root parent, NodeDynamicInfo info) {
        super(parent, info.info.name);
        this.up(info, false);
    }

    Node(Root parent, ApplicationDescriptor appDesc, String nodeName, NodeDescriptor nodeDesc) {
        super(parent, nodeName);
        this.add(appDesc, nodeDesc);
    }

    Node(Root parent, ApplicationDescriptor appDesc, NodeUpdateDescriptor update) {
        super(parent, update.name);
        NodeDescriptor nodeDesc = new NodeDescriptor(update.variables, update.serverInstances, update.servers, update.loadFactor == null ? "" : update.loadFactor.value, update.description == null ? "" : update.description.value, update.propertySets);
        appDesc.nodes.put(this._id, nodeDesc);
        this.add(appDesc, nodeDesc);
    }

    Utils.ExpandedPropertySet expand(PropertySetDescriptor descriptor, String applicationName, Utils.Resolver resolver) {
        Utils.ExpandedPropertySet result = new Utils.ExpandedPropertySet();
        result.references = new Utils.ExpandedPropertySet[descriptor.references.length];
        for (int i = 0; i < descriptor.references.length; ++i) {
            result.references[i] = this.expand(this.findNamedPropertySet(resolver.substitute(descriptor.references[i]), applicationName), applicationName, resolver);
        }
        result.properties = descriptor.properties;
        return result;
    }

    PropertySetDescriptor findNamedPropertySet(String name, String applicationName) {
        ApplicationData appData = (ApplicationData)this._map.get(applicationName);
        if (appData != null) {
            NodeDescriptor descriptor = appData.descriptor;
            PropertySetDescriptor result = (PropertySetDescriptor)descriptor.propertySets.get(name);
            if (result != null) {
                return result;
            }
        }
        return this.getRoot().findNamedPropertySet(name, applicationName);
    }

    void add(ApplicationDescriptor appDesc, NodeDescriptor nodeDesc) {
        Cloneable desc;
        ApplicationData data = new ApplicationData();
        data.descriptor = nodeDesc;
        data.resolver = new Utils.Resolver(new Map[]{appDesc.variables, nodeDesc.variables});
        data.resolver.put("application", appDesc.name);
        data.resolver.put("node", this._id);
        this.putInfoVariables(data.resolver);
        this._map.put(appDesc.name, data);
        Iterator p = nodeDesc.serverInstances.iterator();
        while (p.hasNext()) {
            desc = (ServerInstanceDescriptor)p.next();
            this.insertServer(this.createServer(appDesc, data.resolver, (ServerInstanceDescriptor)desc));
        }
        p = nodeDesc.servers.iterator();
        while (p.hasNext()) {
            desc = (ServerDescriptor)p.next();
            this.insertServer(this.createServer(appDesc, data.resolver, (ServerDescriptor)desc));
        }
    }

    boolean remove(String appName) {
        this._map.remove(appName);
        if (this._map.isEmpty() && !this._up) {
            return true;
        }
        LinkedList<Server> toRemove = new LinkedList<Server>();
        int[] toRemoveIndices = new int[this._children.size()];
        int i = 0;
        for (int index = 0; index < this._children.size(); ++index) {
            Server server = (Server)this._children.get(index);
            if (!server.getApplication().name.equals(appName)) continue;
            toRemove.add(server);
            toRemoveIndices[i++] = index;
        }
        toRemoveIndices = this.resize(toRemoveIndices, toRemove.size());
        this._children.removeAll(toRemove);
        this.getRoot().getTreeModel().nodesWereRemoved(this, toRemoveIndices, toRemove.toArray());
        return false;
    }

    void update(ApplicationDescriptor appDesc, NodeUpdateDescriptor update, boolean variablesChanged, Set serviceTemplates, Set serverTemplates) {
        Iterator p;
        Server server;
        ApplicationData data = (ApplicationData)this._map.get(appDesc.name);
        if (data == null) {
            if (update != null) {
                NodeDescriptor nodeDesc = new NodeDescriptor(update.variables, update.serverInstances, update.servers, update.loadFactor == null ? "" : update.loadFactor.value, update.description == null ? "" : update.description.value, update.propertySets);
                appDesc.nodes.put(this._id, nodeDesc);
                this.add(appDesc, nodeDesc);
            }
            return;
        }
        NodeDescriptor nodeDesc = data.descriptor;
        HashSet<Server> freshServers = new HashSet<Server>();
        if (update != null) {
            Server oldServer;
            Server server2;
            Cloneable desc;
            if (update.description != null) {
                nodeDesc.description = update.description.value;
            }
            if (update.loadFactor != null) {
                nodeDesc.loadFactor = update.loadFactor.value;
            }
            nodeDesc.variables.keySet().removeAll(Arrays.asList(update.removeVariables));
            nodeDesc.variables.putAll(update.variables);
            if (!variablesChanged) {
                variablesChanged = update.removeVariables.length > 0 || !update.variables.isEmpty();
            }
            nodeDesc.propertySets.keySet().removeAll(Arrays.asList(update.removePropertySets));
            nodeDesc.propertySets.putAll(update.propertySets);
            for (int i = 0; i < update.removeServers.length; ++i) {
                server = this.findServer(update.removeServers[i]);
                if (server == null) {
                    String errorMsg = "LiveDeployment/Node: unable to remove server '" + update.removeServers[i] + "'; please report this bug.";
                    this.getCoordinator().getCommunicator().getLogger().error(errorMsg);
                    continue;
                }
                this.removeDescriptor(nodeDesc, server);
                int index = this.getIndex(server);
                this._children.remove(server);
                this.getRoot().getTreeModel().nodesWereRemoved(this, new int[]{index}, new Object[]{server});
            }
            p = update.serverInstances.iterator();
            while (p.hasNext()) {
                desc = (ServerInstanceDescriptor)p.next();
                server2 = this.createServer(appDesc, data.resolver, (ServerInstanceDescriptor)desc);
                oldServer = this.findServer(server2.getId());
                if (oldServer == null) {
                    this.insertServer(server2);
                    freshServers.add(server2);
                    nodeDesc.serverInstances.add(desc);
                    continue;
                }
                this.removeDescriptor(nodeDesc, oldServer);
                oldServer.rebuild(server2);
                freshServers.add(oldServer);
                nodeDesc.serverInstances.add(desc);
            }
            p = update.servers.iterator();
            while (p.hasNext()) {
                desc = (ServerDescriptor)p.next();
                server2 = this.createServer(appDesc, data.resolver, (ServerDescriptor)desc);
                oldServer = this.findServer(server2.getId());
                if (oldServer == null) {
                    this.insertServer(server2);
                    freshServers.add(server2);
                    nodeDesc.servers.add(desc);
                    continue;
                }
                this.removeDescriptor(nodeDesc, oldServer);
                oldServer.rebuild(server2);
                freshServers.add(oldServer);
                nodeDesc.servers.add(desc);
            }
        }
        if (variablesChanged || !serviceTemplates.isEmpty() || !serverTemplates.isEmpty()) {
            p = this._children.iterator();
            while (p.hasNext()) {
                server = (Server)p.next();
                if (server.getApplication() != appDesc || freshServers.contains(server)) continue;
                server.rebuild(data.resolver, variablesChanged, serviceTemplates, serverTemplates);
            }
        }
    }

    NodeInfo getStaticInfo() {
        if (this._info == null) {
            return null;
        }
        return this._info.info;
    }

    boolean isRunningWindows() {
        return this._windows;
    }

    private boolean putInfoVariables(Utils.Resolver resolver) {
        if (this._info == null) {
            return false;
        }
        boolean updated = resolver.put("node.os", this._info.info.os);
        updated = resolver.put("node.hostname", this._info.info.hostname) || updated;
        updated = resolver.put("node.release", this._info.info.release) || updated;
        updated = resolver.put("node.version", this._info.info.version) || updated;
        updated = resolver.put("node.machine", this._info.info.machine) || updated;
        updated = resolver.put("node.datadir", this._info.info.dataDir) || updated;
        return updated;
    }

    void up(NodeDynamicInfo info, boolean fireEvent) {
        Server server;
        this._up = true;
        this._info = info;
        this._windows = info.info.os.toLowerCase().startsWith("windows");
        Iterator<Object> p = this._map.values().iterator();
        while (p.hasNext()) {
            ApplicationData data = (ApplicationData)p.next();
            if (!this.putInfoVariables(data.resolver)) continue;
            String appName = data.resolver.find("application");
            Iterator q = this._children.iterator();
            while (q.hasNext()) {
                Server server2 = (Server)q.next();
                if (!server2.getApplication().name.equals(appName)) continue;
                server2.rebuild(data.resolver, true, null, null);
            }
        }
        HashSet<Server> updatedServers = new HashSet<Server>();
        p = this._info.servers.iterator();
        while (p.hasNext()) {
            ServerDynamicInfo sinfo = (ServerDynamicInfo)p.next();
            server = this.findServer(sinfo.id);
            if (server == null) continue;
            server.update(sinfo.state, sinfo.pid, sinfo.enabled, true);
            updatedServers.add(server);
        }
        p = this._children.iterator();
        while (p.hasNext()) {
            Server server3 = (Server)p.next();
            if (updatedServers.contains(server3)) continue;
            server3.update(ServerState.Inactive, 0, true, true);
        }
        p = this._children.iterator();
        for (int updateCount = 0; p.hasNext() && updateCount < this._info.adapters.size(); updateCount += server.updateAdapters(this._info.adapters)) {
            server = (Server)p.next();
        }
        if (fireEvent) {
            this.getRoot().getTreeModel().nodeChanged(this);
        }
    }

    boolean down() {
        this._up = false;
        this._info.servers.clear();
        this._info.adapters.clear();
        if (this._children.isEmpty()) {
            return true;
        }
        Iterator p = this._children.iterator();
        while (p.hasNext()) {
            Server server = (Server)p.next();
            server.nodeDown();
        }
        this.getRoot().getTreeModel().nodeChanged(this);
        return false;
    }

    void updateServer(ServerDynamicInfo updatedInfo) {
        Server server;
        if (this._info != null) {
            ListIterator<ServerDynamicInfo> p = this._info.servers.listIterator();
            while (p.hasNext()) {
                ServerDynamicInfo sinfo = (ServerDynamicInfo)p.next();
                if (!sinfo.id.equals(updatedInfo.id)) continue;
                p.set(updatedInfo);
                break;
            }
        }
        if ((server = this.findServer(updatedInfo.id)) != null) {
            server.update(updatedInfo.state, updatedInfo.pid, updatedInfo.enabled, true);
        }
    }

    void updateAdapter(AdapterDynamicInfo updatedInfo) {
        Server server;
        Iterator<AdapterDynamicInfo> p;
        if (this._info != null) {
            p = this._info.adapters.listIterator();
            while (p.hasNext()) {
                AdapterDynamicInfo ainfo = (AdapterDynamicInfo)p.next();
                if (!ainfo.id.equals(updatedInfo.id)) continue;
                p.set(updatedInfo);
                break;
            }
        }
        p = this._children.iterator();
        while (p.hasNext() && !(server = (Server)p.next()).updateAdapter(updatedInfo)) {
        }
    }

    ObjectPrx getProxy(String adapterId) {
        if (this._info != null) {
            ListIterator p = this._info.adapters.listIterator();
            while (p.hasNext()) {
                AdapterDynamicInfo ainfo = (AdapterDynamicInfo)p.next();
                if (!ainfo.id.equals(adapterId)) continue;
                return ainfo.proxy;
            }
        }
        return null;
    }

    SortedMap getLoadFactors() {
        TreeMap result = new TreeMap();
        Iterator p = this._map.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            ApplicationData ad = (ApplicationData)entry.getValue();
            String val = ad.resolver.substitute(ad.descriptor.loadFactor);
            if (val.length() == 0) {
                val = "Default";
            }
            result.put(entry.getKey(), val);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showLoad() {
        AMI_Admin_getNodeLoad cb = new AMI_Admin_getNodeLoad(){

            public void ice_response(LoadInfo loadInfo) {
                NumberFormat format;
                if (Node.this._windows) {
                    format = NumberFormat.getPercentInstance();
                    format.setMaximumFractionDigits(1);
                    format.setMinimumFractionDigits(1);
                } else {
                    format = NumberFormat.getNumberInstance();
                    format.setMaximumFractionDigits(2);
                    format.setMinimumFractionDigits(2);
                }
                String load = format.format(loadInfo.avg1) + " " + format.format(loadInfo.avg5) + " " + format.format(loadInfo.avg15);
                SwingUtilities.invokeLater(new Runnable(this, load){
                    private final /* synthetic */ String val$load;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$load = val$load;
                    }

                    public void run() {
                        Node.access$800().setLoad(this.val$load, 3.access$700(this.this$1));
                    }
                });
            }

            public void ice_exception(UserException e) {
                SwingUtilities.invokeLater(new Runnable(this, e){
                    private final /* synthetic */ UserException val$e;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        if (this.val$e instanceof NodeNotExistException) {
                            Node.access$800().setLoad("Error: this node is not known to this IceGrid Registry", 3.access$700(this.this$1));
                        } else if (this.val$e instanceof NodeUnreachableException) {
                            Node.access$800().setLoad("Error: cannot reach this node", 3.access$700(this.this$1));
                        } else {
                            Node.access$800().setLoad("Error: " + this.val$e.toString(), 3.access$700(this.this$1));
                        }
                    }
                });
            }

            public void ice_exception(LocalException e) {
                SwingUtilities.invokeLater(new Runnable(this, e){
                    private final /* synthetic */ LocalException val$e;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        Node.access$800().setLoad("Error: " + this.val$e.toString(), 3.access$700(this.this$1));
                    }
                });
            }

            static /* synthetic */ Node access$700(3 x0) {
                return x0.Node.this;
            }
        };
        try {
            this.getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            AdminPrx admin = this.getCoordinator().getAdmin();
            if (admin == null) {
                _editor.setLoad("Unknown", this);
            } else {
                admin.getNodeLoad_async(cb, this._id);
            }
        }
        catch (LocalException e) {
            _editor.setLoad("Error: " + e.toString(), this);
        }
        finally {
            this.getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private Server createServer(ApplicationDescriptor application, Utils.Resolver resolver, ServerInstanceDescriptor instanceDescriptor) {
        TemplateDescriptor templateDescriptor = (TemplateDescriptor)application.serverTemplates.get(instanceDescriptor.template);
        if (!$assertionsDisabled && templateDescriptor == null) {
            throw new AssertionError();
        }
        ServerDescriptor serverDescriptor = (ServerDescriptor)templateDescriptor.descriptor;
        if (!$assertionsDisabled && serverDescriptor == null) {
            throw new AssertionError();
        }
        Utils.Resolver instanceResolver = new Utils.Resolver(resolver, instanceDescriptor.parameterValues, templateDescriptor.parameterDefaults);
        String serverId = instanceResolver.substitute(serverDescriptor.id);
        instanceResolver.put("server", serverId);
        ServerState serverState = this._up ? ServerState.Inactive : null;
        int pid = 0;
        boolean enabled = true;
        if (this._info != null) {
            Iterator p = this._info.servers.iterator();
            while (p.hasNext()) {
                ServerDynamicInfo sinfo = (ServerDynamicInfo)p.next();
                if (!sinfo.id.equals(serverId)) continue;
                serverState = sinfo.state;
                pid = sinfo.pid;
                enabled = sinfo.enabled;
                break;
            }
        }
        return new Server(this, serverId, instanceResolver, instanceDescriptor, serverDescriptor, application, serverState, pid, enabled);
    }

    private Server createServer(ApplicationDescriptor application, Utils.Resolver resolver, ServerDescriptor serverDescriptor) {
        Utils.Resolver instanceResolver = new Utils.Resolver(resolver);
        String serverId = instanceResolver.substitute(serverDescriptor.id);
        instanceResolver.put("server", serverId);
        ServerState serverState = this._up ? ServerState.Inactive : null;
        int pid = 0;
        boolean enabled = true;
        if (this._info != null) {
            Iterator p = this._info.servers.iterator();
            while (p.hasNext()) {
                ServerDynamicInfo sinfo = (ServerDynamicInfo)p.next();
                if (!sinfo.id.equals(serverId)) continue;
                serverState = sinfo.state;
                pid = sinfo.pid;
                enabled = sinfo.enabled;
                break;
            }
        }
        return new Server(this, serverId, instanceResolver, null, serverDescriptor, application, serverState, pid, enabled);
    }

    private void insertServer(Server server) {
        this.insertSortedChild(server, this._children, this.getRoot().getTreeModel());
    }

    private Server findServer(String id) {
        return (Server)this.find(id, this._children);
    }

    private void removeDescriptor(NodeDescriptor nodeDesc, Server server) {
        ServerInstanceDescriptor instanceDescriptor = server.getInstanceDescriptor();
        if (instanceDescriptor != null) {
            this.removeDescriptor(nodeDesc, instanceDescriptor);
        } else {
            this.removeDescriptor(nodeDesc, server.getServerDescriptor());
        }
    }

    private void removeDescriptor(NodeDescriptor nodeDesc, ServerDescriptor sd) {
        Iterator p = nodeDesc.servers.iterator();
        while (p.hasNext()) {
            if (sd != p.next()) continue;
            p.remove();
            break;
        }
    }

    private void removeDescriptor(NodeDescriptor nodeDesc, ServerInstanceDescriptor sd) {
        Iterator p = nodeDesc.serverInstances.iterator();
        while (p.hasNext()) {
            if (sd != p.next()) continue;
            p.remove();
            break;
        }
    }

    static /* synthetic */ NodeEditor access$800() {
        return _editor;
    }

    static {
        $assertionsDisabled = !Node.class.desiredAssertionStatus();
    }

    static class ApplicationData {
        NodeDescriptor descriptor;
        Utils.Resolver resolver;

        ApplicationData() {
        }
    }
}

