/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Identity;
import Ice.Logger;
import IceInternal.BasicStream;
import IceInternal.TraceLevels;
import IceUtil.StringUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public final class TraceUtil {
    private static Set slicingIds;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void traceHeader(String heading, BasicStream str, Logger logger, TraceLevels tl) {
        if (tl.protocol >= 1) {
            int p = str.pos();
            str.pos(0);
            StringWriter s = new StringWriter();
            s.write(heading);
            TraceUtil.printHeader(s, str);
            logger.trace(tl.protocolCat, s.toString());
            str.pos(p);
        }
    }

    public static void traceRequest(String heading, BasicStream str, Logger logger, TraceLevels tl) {
        if (tl.protocol >= 1) {
            int p = str.pos();
            str.pos(0);
            StringWriter s = new StringWriter();
            s.write(heading);
            TraceUtil.printHeader(s, str);
            int requestId = str.readInt();
            s.write("\nrequest id = " + requestId);
            if (requestId == 0) {
                s.write(" (oneway)");
            }
            TraceUtil.printRequestHeader(s, str);
            logger.trace(tl.protocolCat, s.toString());
            str.pos(p);
        }
    }

    public static void traceBatchRequest(String heading, BasicStream str, Logger logger, TraceLevels tl) {
        if (tl.protocol >= 1) {
            int p = str.pos();
            str.pos(0);
            StringWriter s = new StringWriter();
            s.write(heading);
            TraceUtil.printHeader(s, str);
            int batchRequestNum = str.readInt();
            s.write("\nnumber of requests = " + batchRequestNum);
            for (int i = 0; i < batchRequestNum; ++i) {
                s.write("\nrequest #" + i + ':');
                TraceUtil.printRequestHeader(s, str);
                str.skipEncaps();
            }
            logger.trace(tl.protocolCat, s.toString());
            str.pos(p);
        }
    }

    public static void traceReply(String heading, BasicStream str, Logger logger, TraceLevels tl) {
        if (tl.protocol >= 1) {
            int p = str.pos();
            str.pos(0);
            StringWriter s = new StringWriter();
            s.write(heading);
            TraceUtil.printHeader(s, str);
            int requestId = str.readInt();
            s.write("\nrequest id = " + requestId);
            byte status = str.readByte();
            s.write("\nreply status = " + status + ' ');
            switch (status) {
                case 0: {
                    s.write("(ok)");
                    break;
                }
                case 1: {
                    s.write("(user exception)");
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    switch (status) {
                        case 2: {
                            s.write("(object not exist)");
                            break;
                        }
                        case 3: {
                            s.write("(facet not exist)");
                            break;
                        }
                        case 4: {
                            s.write("(operation not exist)");
                            break;
                        }
                        default: {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            break;
                        }
                    }
                    TraceUtil.printIdentityFacetOperation(s, str);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    switch (status) {
                        case 7: {
                            s.write("(unknown exception)");
                            break;
                        }
                        case 5: {
                            s.write("(unknown local exception)");
                            break;
                        }
                        case 6: {
                            s.write("(unknown user exception)");
                            break;
                        }
                        default: {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            break;
                        }
                    }
                    String unknown = str.readString();
                    s.write("\nunknown = " + unknown);
                    break;
                }
                default: {
                    s.write("(unknown)");
                }
            }
            logger.trace(tl.protocolCat, s.toString());
            str.pos(p);
        }
    }

    static synchronized void traceSlicing(String kind, String typeId, String slicingCat, Logger logger) {
        if (slicingIds.add(typeId)) {
            StringWriter s = new StringWriter();
            s.write("unknown " + kind + " type `" + typeId + "'");
            logger.trace(slicingCat, s.toString());
        }
    }

    public static void dumpStream(BasicStream stream) {
        int inc = 8;
        int pos = stream.pos();
        stream.pos(0);
        byte[] data = stream.readBlob(stream.size());
        TraceUtil.dumpOctets(data);
        stream.pos(pos);
    }

    public static void dumpOctets(byte[] data) {
        int inc = 8;
        for (int i = 0; i < data.length; i += 8) {
            int j = i;
            while (j - i < 8) {
                if (j < data.length) {
                    int n = data[j];
                    if (n < 0) {
                        n += 256;
                    }
                    String s = n < 10 ? "  " + n : (n < 100 ? " " + n : "" + n);
                    System.out.print(s + " ");
                } else {
                    System.out.print("    ");
                }
                ++j;
            }
            System.out.print('\"');
            for (j = i; j < data.length && j - i < 8; ++j) {
                if (data[j] >= 32 && data[j] < 127) {
                    System.out.print((char)data[j]);
                    continue;
                }
                System.out.print('.');
            }
            System.out.println('\"');
        }
    }

    private static void printIdentityFacetOperation(Writer out, BasicStream stream) {
        block3: {
            try {
                Identity identity = new Identity();
                identity.__read(stream);
                out.write("\nidentity = " + stream.instance().identityToString(identity));
                String[] facet = stream.readStringSeq();
                out.write("\nfacet = ");
                if (facet.length > 0) {
                    out.write(StringUtil.escapeString(facet[0], ""));
                }
                String operation = stream.readString();
                out.write("\noperation = " + operation);
            }
            catch (IOException ex) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    private static void printRequestHeader(Writer out, BasicStream stream) {
        block8: {
            TraceUtil.printIdentityFacetOperation(out, stream);
            try {
                byte mode = stream.readByte();
                out.write("\nmode = " + mode + ' ');
                switch (mode) {
                    case 0: {
                        out.write("(normal)");
                        break;
                    }
                    case 1: {
                        out.write("(nonmutating)");
                        break;
                    }
                    case 2: {
                        out.write("(idempotent)");
                        break;
                    }
                    default: {
                        out.write("(unknown)");
                    }
                }
                int sz = stream.readSize();
                out.write("\ncontext = ");
                while (sz-- > 0) {
                    String key = stream.readString();
                    String value = stream.readString();
                    out.write(key + '/' + value);
                    if (sz <= 0) continue;
                    out.write(", ");
                }
            }
            catch (IOException ex) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
    }

    private static void printHeader(Writer out, BasicStream stream) {
        block14: {
            try {
                byte magic = stream.readByte();
                magic = stream.readByte();
                magic = stream.readByte();
                magic = stream.readByte();
                byte pMajor = stream.readByte();
                byte pMinor = stream.readByte();
                byte eMajor = stream.readByte();
                byte eMinor = stream.readByte();
                byte type = stream.readByte();
                out.write("\nmessage type = " + type + ' ');
                switch (type) {
                    case 0: {
                        out.write("(request)");
                        break;
                    }
                    case 1: {
                        out.write("(batch request)");
                        break;
                    }
                    case 2: {
                        out.write("(reply)");
                        break;
                    }
                    case 4: {
                        out.write("(close connection)");
                        break;
                    }
                    case 3: {
                        out.write("(validate connection)");
                        break;
                    }
                    default: {
                        out.write("(unknown)");
                    }
                }
                byte compress = stream.readByte();
                out.write("\ncompression status = " + compress + ' ');
                switch (compress) {
                    case 0: {
                        out.write("(not compressed; do not compress response, if any)");
                        break;
                    }
                    case 1: {
                        out.write("(not compressed; compress response, if any)");
                        break;
                    }
                    case 2: {
                        out.write("(compressed; compress response, if any)");
                        break;
                    }
                    default: {
                        out.write("(unknown)");
                    }
                }
                int size = stream.readInt();
                out.write("\nmessage size = " + size);
            }
            catch (IOException ex) {
                if ($assertionsDisabled) break block14;
                throw new AssertionError();
            }
        }
    }

    static {
        $assertionsDisabled = !TraceUtil.class.desiredAssertionStatus();
        slicingIds = new HashSet();
    }
}

